//
//  ProductsPerStoreViewController.swift
//  We1lAdmin
//
//  Created by omar altayyan on 11/1/18.
//  Copyright © 2018 juger. All rights reserved.
//


import Autotech


class ProductsPerStoreViewController: ATEntityListVC, UIPickerViewDelegate, UIPickerViewDataSource
{
    
    @IBOutlet weak var storesPicker: UIPickerView!

    let storesLoadingOPKey = "Stores"
    
    var storesArray: NSArray = []
    
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        return storesArray.count
    }
    
    func pickerView(_ pickerView: UIPickerView, attributedTitleForRow row: Int, forComponent component: Int) -> NSAttributedString? {
        let dataElement = storesArray[row] as! NSDictionary
        
        let name = dataElement["Name"] as? String ?? ""
        
        return NSAttributedString(string: name, attributes: [NSAttributedString.Key.foregroundColor: UIColor.white])
    }
    
    
    func pickerView(_ pickerView: UIPickerView, didSelectRow row: Int, inComponent component: Int) {
        reloadData()
    }
    
    
    
    override func viewDidLoad() {
        self.embeddingMode = .staticUnSegueableTableOnly

        super.viewDidLoad()
        
        
        storesPicker.dataSource = self
        storesPicker.delegate = self
    }
    
    override func getOperationKey() -> String
    {
        if storesArray.count == 0
        {
            return storesLoadingOPKey
        }
        return "Products Per Store"
    }
    
    override func getCellReuseIdentifier() -> String
    {
        return "productsPerStoreTableCell"
    }
    
    override func dataRequestPostDict() -> PostDict {
        if storesArray.count == 0
        {
            return [:]
        }
        
        let selectedIndex = storesPicker.selectedRow(inComponent: 0)
        
        let dataElement = storesArray[selectedIndex] as! NSDictionary
        
        let storeID = dataElement["ID"] as! Int
        
        return ["Store": "\(storeID)"]
    }
    
    override func dataRequestEndPointPostfix() -> String {
        if storesArray.count == 0
        {
            return storesURLPostfix
        }
        
        return productsPerStoreURLPostfix

    }
    
    
    override func requestSuccess(withLoadedData data: NSDictionary, withContext context: String?) {
        
        super.requestSuccess(withLoadedData: data, withContext: context)
        
        if context != nil && context! == storesLoadingOPKey
        {
            storesArray = data["Data"] as! NSArray
            storesPicker.reloadAllComponents()
            reloadData()
        }
        
    }

}

